﻿using System;

class Program
{
    static void Main(string[] args)
    {
        StoppUhr su = new StoppUhr();
        su.Start();

        Console.WriteLine("Standard-Enumeration - eine Integer Sammlung");

        Console.WriteLine("a(string)=" + Konstanten.a);
        Console.WriteLine("a(int)=" + (int)Konstanten.a);
        Console.WriteLine("b(int)=" + (int)Konstanten.b);
        Console.WriteLine("c(int)=" + (int)Konstanten.c);
        Console.WriteLine("d(int)=" + (int)Konstanten.d);

        //TestStoppUhr(ref su);
        TestStoppUhr(su);

        if (ByteKonstanten.a == (ByteKonstanten)0)
        {
            Console.WriteLine("Spezielle-Enumeration - diesmal von byte Werten");

            Console.WriteLine("a(string)=" + ByteKonstanten.a);
            Console.WriteLine("a(int)=" + (int)ByteKonstanten.a);
            Console.WriteLine("b(int)=" + (int)ByteKonstanten.b);
            Console.WriteLine("c(int)=" + (int)ByteKonstanten.c);
            Console.WriteLine("d(int)=" + (int)ByteKonstanten.d);

        }

        System.Threading.Thread.Sleep(15);
        Console.WriteLine("Vergangene Zeit: " + su.Ellapsed() + "ms");
        Console.Read();
    }

    static void TestStoppUhr(ref StoppUhr su)
    {
        su.Stopp();
        Console.WriteLine("Vergangene Zeit: " + su.Ellapsed() + "ms");
    }

    static void TestStoppUhr(StoppUhr su)
    {
        TestStoppUhr(ref su);
    }
}

//class StoppUhr
struct StoppUhr
{
    DateTime startZeit;
    DateTime endZeit;
    bool running;

    public void Start()
    {
        running = true;
        startZeit = DateTime.Now;
    }

    public void Stopp()
    {
        if (!running)
            return;
            
        endZeit = DateTime.Now;
        running = false;
    }

    public double Ellapsed()
    {
        if (running)
            return DateTime.Now.Subtract(startZeit).TotalMilliseconds;
        
        return endZeit.Subtract(startZeit).TotalMilliseconds;
    }
}

enum Konstanten
{
    a,
    b = 4,
    c,
    d = 2,
}

enum ByteKonstanten : byte
{
    a,
    b,
    c = 0x9,
    d,
}
